# System Reference Document 1.0.0

#### Credits

Version 1.0.0 • May 2022

Writing, design, artwork, and layout by David Garrett

Published by Amalara Game Studio

VRBS System Reference Document copyright © 2022 by David Garrett. Licensed for use under the [Creative Commons Attribution 4.0](https://creativecommons.org/licenses/by/4.0/) license.

Made with heart () in Cleveland

[https://amalara.com](https://amalara.com)

# Introduction

*Words create worlds.*

VRBS is an ultralight system for creating highly improvisational role-playing games that reward creative, heroic action. It has a **universal conflict resolution** mechanic that requires a single six-sided die and is easy enough for a six-year old to master.

In VRBS, characters are defined by **what they do**, not by abstract statistics. Characters can attempt anything that a creative hero would be able to reasonably accomplish and they either succeed or grow in the process.

VRBS supports **zero-prep, GM-less play** for **solo and team games**. Scenarios are generated at play time and the players collaboratively interpret prompts to drive the story forward.

VRBS is best suited to a **short, episodic style** of play that encourages creativity in both young and old.

## System reference document

This **system reference document** (abbreviated SRD) contains all of the available mechanics for the VRBS system as well as guidance on how to use them to create your own game. It is intended primarily for game designers and homebrewers — not directly for players.

This entire SRD is licensed under the Creative Commons Attribution 4.0 license, which gives you the right to use as many or as few of the concepts and words as you’d like in your own games, settings, adventures, and other content, as long as you make a clear statement that your material is based on these rules.

To do so, add the following text wherever you put your own copyright statement:

> This work is based on [VRBS](https://amalara.com/vrbs) (https://amalara.com/vrbs), designed and authored by David Garrett and licensed for use under the [Creative Commons Attribution 4.0](https://creativecommons.org/licenses/by/4.0/) (https://creativecommons.org/licenses/by/4.0/) license.

If you’re publishing your work digitally, you can omit the printed URLs. As long as you adhere to these guidelines, you are also free to use the VRBS logo to indicate compatibility with the VRBS system.

## Using this document

Much of the text in the SRD is intentionally written in second person so that you can simply copy and paste it into your own game document, should you so choose.

> Designer comments are set apart from the rule text so that I can provide guidance and suggestions that you wouldn’t want to copy and paste.

`Keywords` are set in monospaced font in order to indicate that they have special meaning within the context of this game.

# Design principles

VRBS is built on two core principles. First, that we are what we do. Anyone can have good intentions, but heroes act on those intentions. Therefore, characters are, at least from a mechanical standpoint, defined entirely by their actions — by the verbs that give the system its name.

Second, that we learn by doing and making mistakes. Heroic characters are capable of a great deal, but everyone becomes better by trying and failing. Practice leads directly to growth — each time a character uses a verb to take an action and fails, they improve at using that verb.

Characters can also learn new verbs simply by trying. If they succeed, the success is its own reward. If they fail, then they get to add a new verb to their character sheet. In this sense, characters are always winning or learning.

Further, the capacity for heroes to do heroic stuff is measured not by hit points or a health gauge, but by how many verbs they possess. As characters grow, not only do they become better at each individual verb, they become a more capable hero overall.

VRBS also encourages creative risk-taking through its conflict resolution mechanic — the die roll. Instead of determining whether a character is successful or not, the die determines how much effort they spent to accomplish what they were attempting. On a good roll, the character becomes energized. On a bad roll, the character is fatigued. Either way, they accomplish what they set out to do.

Failure is possible, but it only happens at the end of a story, after a character (or their team) completely runs out of steam. No single die roll is responsible for the success or failure of an entire storyline.

#### Building your game

> You can use the following as a template for your own VRBS game or you can simply use it for inspiration. It contains the full text needed to run a game written in a genre-neutral style along with placeholders for you to fill in your own content.

To play this game, you’ll need the following in either analogue or digital form:

- An active imagination, a desire to be creative, and a place where you can focus.
- Some scratch paper and copies of the character sheet at the end of this book.
- One six-sided die (abbreviated `D6`).

# Your character

Each person in your group should do the following to create their character:

1. Pick your name, pronouns, and physical description.
2. Pick three `verbs` from the suggested list and add them to your character sheet with one `tally` mark per verb. These are the things that you’re good at doing.

## Suggested verbs

> Supply two to three dozen verbs that represent the sorts of things that heroes in your game normally do.

# Your mission

> Feel free to change the keyword “mission” to “quest,” “adventure,” “episode,” or whatever fits the genre and style of your game.

Each day, you and your fellow team members embark on a heroic `mission`. Choose or roll `1d6` four times to determine your mission.

> Now create a mission prompt that fits your game. A sample prompt is below. Try to answer the questions WHO, WHAT, and WHY.

A villain, THE ANTAGONIST, hatches a plan to ACTION the OBJECT in order to MOTIVE.

> For each placeholder in the preceding prompt, supply a table for the players to roll on. Since VRBS only requires a single `d6`, give six options for each.

# Your story

Your team starts each mission with a pool of `energy` that contains as many points as you collectively have `verbs` on your character sheets. Choose or roll `1d6` three times to set the scene.

> As with the mission, each scene is generated by filling in placeholder words in a prompt. Here, you’ll need to answer WHAT the characters are trying to accomplish, WHERE they are trying to accomplish it, and HOW they are constrained in their efforts.

Your character has to WHAT in a WHERE, but you have to make sure you do it HOW.

> As with the mission prompt, you’ll need to supply six options for each of the placeholders in the scene prompt.

Take turns describing your actions. Each time you try something interesting, roll `1d6`. You can try any action, but if you have the `verb` for your action on your character sheet, add its `tally` marks to your roll.

| **Roll** | **Result**  | **Consequence**                                                                  |
| -------- | ----------- | -------------------------------------------------------------------------------- |
| 1-4      | Failure     | You get what you want, but something unexpected happens and you lose one energy. |
| 5-6      | Success     | You get what you want.                                                           |
| 7+       | Big success | You get what you want and add one energy.                                        |

If you fail, add a tally next to the verb that you used, to a maximum of 3. If you try something that’s not on your character sheet, don't add anything to your roll, but if you fail, add the verb to your list with one tally.

The result of your die roll determines what happens. Narrate your suave `success` or your disastrous `failure`. If you fail, your team loses one point of `energy`, but if you get a `big success`, then you add one point. You can have more energy than you started with.

Once you feel that your team has made satisfying progress and each member of your team has had a chance to roll the dice at least once, you may draw the scene to a close. Choose or roll your next scene. You can even create your own scene if you have a good feel for where the story is headed next.

Repeat this process until you’ve played through three scenes, plus one scene for each member of your group. The `final scene` will always be the climax of your story. If you make it through the end of the final scene before your team runs out of `energy`, then you win!

If your team runs out of energy before reaching the end, though, then your mission is over. You return home to get ready for your next mission, tomorrow.

